/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.helper.DecoHelperRandomSplit;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPDeadForest
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.dead_forest.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPDeadForest() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPDeadForest(58.0f, 80.0f, 30.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPDeadForest(this.getConfig(), RealisticBiomeBOPDeadForest.biome.field_76752_A, RealisticBiomeBOPDeadForest.biome.field_76753_B, RealisticBiomeBOPDeadForest.biome.field_76752_A, RealisticBiomeBOPDeadForest.biome.field_76753_B, 80.0f, -0.15f, 10.0f, 0.5f);
    }

    @Override
    public void initDecos() {
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setChance(16);
        decoBoulder.setMaxY(95);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree1 = new DecoFallenTree();
        decoFallenTree1.setLoops(1);
        decoFallenTree1.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree1.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree1.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree1.setLogConditionChance(10);
        decoFallenTree1.setMaxY(100);
        decoFallenTree1.setLogBlock(BOPBlocks.log_3.func_176203_a(2));
        decoFallenTree1.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        decoFallenTree1.setMinSize(3);
        decoFallenTree1.setMaxSize(5);
        DecoFallenTree decoFallenTree2 = new DecoFallenTree();
        decoFallenTree2.setLoops(1);
        decoFallenTree2.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree2.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree2.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree2.setLogConditionChance(10);
        decoFallenTree2.setMaxY(100);
        decoFallenTree2.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree2.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree2.setMinSize(3);
        decoFallenTree2.setMaxSize(5);
        DecoHelperRandomSplit decoHelperRandomSplit = new DecoHelperRandomSplit();
        decoHelperRandomSplit.decos = new DecoBase[]{decoFallenTree2, decoFallenTree1};
        decoHelperRandomSplit.chances = new int[]{12, 1};
        this.addDeco(decoHelperRandomSplit, this.getConfig().ALLOW_LOGS.get());
    }

    public static class SurfaceBOPDeadForest
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceBOPDeadForest(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPDeadForest
    extends TerrainBase {
        private float minHeight = 58.0f;
        private float maxHeight = 120.0f;
        private float hillStrength = 30.0f;
        private float deadForestGroundAmplitude = 10.0f;

        public TerrainBOPDeadForest() {
        }

        public TerrainBOPDeadForest(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
            this.hillStrength = hillStrength;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPDeadForest.terrainRollingHills(x, y, rtgWorld, river, this.hillStrength, this.maxHeight, this.deadForestGroundAmplitude, 0.0f);
        }
    }
}

